{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 09/10/99
 * Ultim dia:  10/10/99
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit Unitabout;

{*******************************************************}
interface
{*******************************************************}

uses Windows, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, MMSystem, ShellApi, Dialogs;

type
  TAboutBox = class(TForm)
    OKButton: TBitBtn;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    Panel1: TPanel;
    Bevel2: TBevel;
    Panel2: TPanel;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    ImageOrdinador: TImage;
    ImageOrella: TImage;
    Timer1: TTimer;
    Label2: TLabel;
    Timer2: TTimer;
    Memo1: TMemo;
    Image3: TImage;
    ImageMonica: TImage;
    ImageInteligencia: TImage;
    Image4: TImage;
    procedure Image2Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label2Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CopyrightClick(Sender: TObject);
    procedure ProductNameClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Panel1Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure Panel2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CommentsClick(Sender: TObject);
    procedure ImageMonicaClick(Sender: TObject);
    procedure ImageInteligenciaClick(Sender: TObject);
    procedure Image4Click(Sender: TObject);
    procedure VersionClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;
  //BoolInformacioCopyRight:integer;

procedure Pausa(t:integer);

{*******************************************************}
implementation
{*******************************************************}

{$R *.DFM}

procedure Pausa(t:integer);
var
  TheTime:LongInt;
begin
  TheTime:=GetTickCount+t;
  while GetTickCount<TheTime do Application.ProcessMessages;
end;

{************************************************}
procedure TAboutBox.FormCreate(Sender: TObject);
begin
  Memo1.ReadOnly:=true;
  //BoolInformacioCopyRight:=0;
end;

procedure TAboutBox.FormShow(Sender: TObject);
begin
  Timer1.Enabled:=true;
  Timer2.Enabled:=true;
end;

procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer1.Enabled:=false;
  Timer2.Enabled:=false;
  //sndPlaySound(nil,SND_ASYNC);
end;

procedure TAboutBox.FormDestroy(Sender: TObject);
begin
  //if BoolInformacioCopyRight=1 then FormInformacioCopyRight.ShowModal;
end;

procedure TAboutBox.FormClick(Sender: TObject);
begin
  if Memo1.Visible then Memo1.Visible:=false else Memo1.Visible:=true;
end;

{*******************************************************}
procedure TAboutBox.Image2Click(Sender: TObject);
begin
  //Label1.Visible:=false;
  Image2.Visible:=False;
  Image1.Visible:=true;
end;

procedure TAboutBox.Image1Click(Sender: TObject);
begin
  //Image2.Visible:=False;
  Image1.Visible:=False;
  //Label1.Visible:=true;
  ImageInteligencia.Visible:=true;
end;

procedure TAboutBox.Label1Click(Sender: TObject);
begin
  //Image1.Visible:=true;
  //Label1.Visible:=false;
  //Label2.Visible:=true;
  ImageInteligencia.Visible:=false;
  ImageMonica.Visible:=true;
end;

procedure TAboutBox.Label2Click(Sender: TObject);
begin
  //Label2.Visible:=false;
  ImageMonica.Visible:=false;
  Image2.Visible:=true;
end;

procedure TAboutBox.Timer1Timer(Sender: TObject);
begin
  if Image1.Visible then begin
    Image1.Visible:=False;
    //Label1.Visible:=true;
    ImageInteligencia.Visible:=true;
  //end else if Label1.Visible then begin
  end else if ImageInteligencia.Visible then begin
    //Label1.Visible:=false;
    //Label2.Visible:=true;
    ImageInteligencia.Visible:=false;
    ImageMonica.Visible:=true;
  //end else if Label2.Visible then begin
  end else if ImageMonica.Visible then begin
    //Label2.Visible:=false;
    ImageMonica.Visible:=false;
    Image2.Visible:=true;
    //Comments.Alignment:=taLeftJustify;
    //Comments.Caption:='Toti PM Software en col.laboraci amb l''E.A. al Deficient Visual i l''E.E.E. Palau (Girona)';
  end else if Image2.Visible then begin
    Image2.Visible:=False;
    Image1.Visible:=true;
  end;
end;

procedure TAboutBox.Timer2Timer(Sender: TObject);
begin
  if ImageOrdinador.Visible then begin
    ImageOrdinador.Visible:=false;
    ImageOrella.Visible:=true;
  end else begin
    ImageOrdinador.Visible:=true;
    ImageOrella.Visible:=false;
  end;
end;

procedure TAboutBox.CopyrightClick(Sender: TObject);
begin
  ShellExecute(0, Nil, 'http://www.lagares.org', Nil, Nil, SW_NORMAL);
end;

procedure TAboutBox.ProductNameClick(Sender: TObject);
begin
  ShellExecute(0, Nil, 'http://www.lagares.org', Nil, Nil, SW_NORMAL);
end;

procedure TAboutBox.Panel1Click(Sender: TObject);
begin
  Panel1.Visible:=false;
  Panel2.Visible:=false;
  Image3.Visible:=True;
end;

procedure TAboutBox.Image3Click(Sender: TObject);
begin
  Image3.Visible:=false;
  Panel1.Visible:=true;
  Panel2.Visible:=true;
end;

procedure TAboutBox.Panel2Click(Sender: TObject);
begin
  if Memo1.Visible then Memo1.Visible:=false else Memo1.Visible:=true;
end;

procedure TAboutBox.CommentsClick(Sender: TObject);
begin
  Comments.Alignment:=taLeftJustify;
  Comments.Caption:='Toti PM Software en col.laboraci amb l''Escola d''Educaci Especial de Palau de Girona';
end;

procedure TAboutBox.ImageMonicaClick(Sender: TObject);
begin
  ImageMonica.Visible:=false;
  Image2.Visible:=true;
end;

procedure TAboutBox.ImageInteligenciaClick(Sender: TObject);
begin
  ImageInteligencia.Visible:=false;
  ImageMonica.Visible:=true;
end;

procedure TAboutBox.Image4Click(Sender: TObject);
begin
  Panel1Click(nil);
end;

procedure TAboutBox.VersionClick(Sender: TObject);
begin
  Panel1Click(nil);
end;

end.

